@extends($activeTemplate . 'layouts.master')

@section('content')
    <!-- dashboard start -->
    <section class="pt-100 pb-100 section--bg">
        <div class="container">

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">

                        <div class="card-body p-0">

                            <div class="table-responsive--md">
                                <table class="table custom--table">
                                    <thead>
                                        <tr>
                                            <th>@lang('Subject')</th>
                                            <th>@lang('Status')</th>
                                            <th>@lang('Priority')</th>
                                            <th>@lang('Last Reply')</th>
                                            <th>@lang('Action')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($supports as $support)
                                            <tr>
                                                <td> <a href="{{ route('ticket.view', $support->ticket) }}" class="text--base fw-bold"> [@lang('Ticket')#{{ $support->ticket }}] {{ __($support->subject) }} </a></td>
                                                <td>
                                                    @php echo $support->statusBadge; @endphp
                                                </td>
                                                <td>
                                                    @if ($support->priority == Status::PRIORITY_LOW)
                                                        <span class="badge badge-dark style--light ">@lang('Low')</span>
                                                    @elseif($support->priority == Status::PRIORITY_MEDIUM)
                                                        <span class="badge  badge-warning style--light ">@lang('Medium')</span>
                                                    @elseif($support->priority == Status::PRIORITY_HIGH)
                                                        <span class="badge badge-danger style--light ">@lang('High')</span>
                                                    @endif
                                                </td>
                                                <td>{{ diffForHumans($support->last_reply) }} </td>

                                                <td>
                                                    <a href="{{ route('ticket.view', $support->ticket) }}" class="icon-btn text-white bg-primary">
                                                        <i class="las la-desktop"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="100%" class="text-center">{{ __($emptyMessage) }}</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                            {{ paginateLinks($supports) }}
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
@endsection
@push('script')
    <script>
        "use strict";
        $('.main-wrapper').addClass('section--bg');
    </script>
@endpush
