@extends($activeTemplate . 'layouts.master')
@section('content')
    <section class="pt-100 pb-100 section--bg">
        <div class="container">

            <!--  New Ticket Section  -->
            <div class="new-ticket-section pr-2 pl-2">
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <div class="ticket-wrapper rounded card p-4">
                            <div class="button-contain-header text-end">
                                <a href="{{ route('ticket.index') }}" class="cmn-btn bg-primary">@lang('My Tickets')</a>
                            </div>
                            <form action="{{ route('ticket.store') }}" class="ticket_form mb--20 row disableSubmission"
                                  method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label">@lang('Subject')</label>
                                        <input type="text" name="subject" value="{{ old('subject') }}" class="form-control form--control" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label">@lang('Priority')</label>
                                        <select name="priority" class="form-select form--control select2-basic" data-minimum-results-for-search="-1" required>
                                            <option value="3">@lang('High')</option>
                                            <option value="2">@lang('Medium')</option>
                                            <option value="1">@lang('Low')</option>
                                        </select>
                                    </div>
                                    <div class="col-12 form-group">
                                        <label class="form-label">@lang('Message')</label>
                                        <textarea name="message" id="inputMessage" rows="6" class="form-control form--control" required>{{ old('message') }}</textarea>
                                    </div>


                                    <div class="col-md-9">
                                        <button type="button" class="btn bg-primary btn-sm addAttachment my-2 text-white">
                                            <i class="fas fa-plus"></i> @lang('Add Attachment') </button>
                                        <p class="mb-2"><span class="text--info">@lang('Max 5 files can be uploaded | Maximum upload size is ' . convertToReadableSize(ini_get('upload_max_filesize')) . ' | Allowed File Extensions: .jpg, .jpeg, .png, .pdf, .doc, .docx')</span></p>
                                        <div class="row g-3 fileUploadsContainer">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <button class="cmn-btn w-100 my-2" type="submit"><i class="las la-paper-plane"></i>
                                            @lang('Submit')
                                        </button>
                                    </div>
                                </div>
                            </form>


                        </div>
                    </div>
                </div>
            </div>
            <!--  New Ticket Section  -->

        </div>
    </section>
@endsection


@push('style')
    <style>
        .select2-container {
            width: 100% !important;
        }

        .select2-container .selection {
            width: 100%;
        }

        .select2-container--default .select2-selection--single {
            border-width: 1px !important;
            border-color: #e5e5e5 !important;
            border-radius: 3px !important;
        }

        .select2-container--open .select2-selection.select2-selection--single,
        .select2-container--open .select2-selection.select2-selection--multiple {
            border-radius: 3px !important;
        }

        .select2-container--default .select2-search--dropdown .select2-search__field {
            border-radius: 3px;
        }

        .select2-container--default .select2-search--dropdown .select2-search__field:focus {
            border-color: hsl(var(--base)) !important;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            top: 10px !important;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            color: #363636;
            line-height: 36px;
        }

        .input-group-text:focus {
            box-shadow: none !important;
        }

        .fileUploadsContainer .input-group .input-group-text {
            color: #fff;
            border-color: #ff3535;
            background-color: #ff3535 !important;
        }

        .fileUploadsContainer input[type="file"]::file-selector-button {
            margin: -10px 4px -10px -20px;
            padding: 12px 10px;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addAttachment').on('click', function() {
                fileAdded++;
                if (fileAdded == 5) {
                    $(this).attr('disabled', true)
                }
                $(".fileUploadsContainer").append(`
                    <div class="col-lg-4 col-md-12 removeFileInput">
                        <div class="input-group">
                            <input type="file" name="attachments[]" class="form-control" accept=".jpeg,.jpg,.png,.pdf,.doc,.docx" required>
                            <button type="button" class="input-group-text removeFile bg--danger border--danger"><i class="fas fa-times"></i></button>
                        </div>
                    </div>
                `)
            });
            $(document).on('click', '.removeFile', function() {
                $('.addAttachment').removeAttr('disabled', true)
                fileAdded--;
                $(this).closest('.removeFileInput').remove();
            });

            $(document).ready(function() {
                $('.select2-basic').select2();
            });

        })(jQuery);
    </script>
@endpush
