@extends($activeTemplate . 'layouts.master')
@section('content')
    <section class="pt-100 pb-100 section--bg">
        <div class="container">
            <div class="row justify-content-center mb-none-30">

                @forelse($services as $index => $data)
                    <div class="col-lg-4 col-md-6 mb-30">
                        <div class="d-widget">

                            <h3 class="text-center">
                                {{ __($data->name) }} <small>( {{ __($data->category->name) }} )</small>
                            </h3>

                            <div class="mt-4 mb-4 text-center">
                                <ul>
                                    <li>
                                        <span class="font-weight-bold">@lang('Processing Time')</span>
                                        <span class="">{{ __($data->delay) }}</span>
                                    </li>
                                    <li>
                                        <span class="font-weight-bold">@lang('Fixed Charge')</span>
                                        <span class="">{{ getAmount($data->fixed_charge) }} {{ __(gs()->cur_text) }}</span>
                                    </li>
                                    <li>
                                        <span class="font-weight-bold">@lang('Parcent Charge')</span>
                                        <span class="">{{ getAmount($data->percent_charge) }} %</span>
                                    </li>
                                </ul>
                            </div>

                            <div class="price-footer">
                                <a href="javascript:void(0)" class="cmn-btn bg-primary w-100 text-center apply" data-bs-toggle="modal" data-bs-target="#applyModal" data-id="{{ $data->id }}"
                                   data-fix_charge="{{ getAmount($data->fixed_charge) }}" data-percent_charge="{{ getAmount($data->percent_charge) }}" data-category="{{ __($data->category->name) }}"
                                   data-service="{{ __($data->name) }}">@lang('Continue')</a>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="empty mt-5">
                        <h3>{{ __($emptyMessage) }}</h3>
                    </div>
                @endforelse

            </div>

            {{ $services->links() }}

        </div>
    </section>

    <div class="modal fade" id="applyModal" tabindex="-1" role="dialog" aria-labelledby="depositModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header ">
                    <h5 class="modal-title method-name" id="depositModal"></h5>
                    <button type="button" class="close bg-transparent" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times text-black"></i>
                    </button>
                </div>
                <form action="{{ route('user.service.apply') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <p class="text-dark service" style="font-weight: bold;"></p>
                        <p class="text-dark charge" style="font-weight: bold;"></p>
                        <input type="hidden" name="id">
                        <div class="form-group">
                        </div>
                        <div class="form-group">
                            <label for="amount">@lang('Amount')</label>
                            <div class="input-group">
                                <input id="amount" type="text" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="amount" name="amount" placeholder="0.00"
                                       required="" value="{{ old('amount') }}">
                                <span class="input-group-text currency-addon addon-bg bg-primary text-white border-0">{{ __(gs()->cur_text) }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-dark" data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="btn bg-primary text-white ">@lang('Confirm')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection



@push('script')
    <script>
        (function($) {

            "use strict";

            $('.apply').on('click', function() {
                var modal = $('#applyModal');
                modal.find('input[name=id]').val($(this).data('id'));
                var baseSymbol = "{{ __(gs()->cur_text) }}";
                var fixCharge = $(this).data('fix_charge');
                var percentCharge = $(this).data('percent_charge');
                var category = $(this).data('category');
                var service = $(this).data('service');
                $('.method-name').text(`@lang('Enter Amount for ') ${category}`);
                var service = `@lang('Service'): ${service}`;
                $('.service').text(service);
                var charge = `@lang('Charge'): ${fixCharge} ${baseSymbol}  ${(0 < percentCharge) ? ' + ' +percentCharge + ' % ' : ''}`;
                $('.charge').text(charge);
            });

        })(jQuery);
    </script>
@endpush
