@extends($activeTemplate . 'layouts.master')
@section('content')
    <!-- dashboard start -->
    <section class="pt-120 pb-120 section--bg">
        <div class="container">

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">

                        <div class="card-body p-0">
                            <div class="table-responsive--md">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>@lang('Category')</th>
                                            <th>@lang('Service')</th>
                                            <th>@lang('Amount')</th>
                                            <th>@lang('Charge')</th>
                                            <th>@lang('After Charge')</th>
                                            <th>@lang('Post Balance')</th>
                                            <th>@lang('Select')</th>
                                            <th>@lang('Status')</th>
                                            <th>@lang('Date')</th>
                                            <th>@lang('Detail')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($histories as $data)
                                            <tr>
                                                <td>
                                                    {{ __(@$data->service->category->name) }}
                                                </td>
                                                <td>
                                                    {{ __(@$data->service->name) }}
                                                </td>
                                                <td>
                                                    {{ getAmount($data->amount) }}
                                                    {{ __(gs()->cur_text) }}
                                                </td>
                                                <td>
                                                    {{ getAmount($data->total_charge) }}
                                                    {{ __(gs()->cur_text) }}
                                                </td>
                                                <td>
                                                    {{ getAmount($data->after_charge) }}
                                                    {{ __(gs()->cur_text) }}
                                                </td>
                                                <td>
                                                    {{ getAmount($data->post_balance) }}
                                                    {{ __(gs()->cur_text) }}
                                                </td>
                                                <td>
                                                    @if ($data->select_field)
                                                        @php
                                                            $array = (array) json_decode($data->select_field);
                                                            $serviceType = key($array);
                                                            $service = array_values($array);
                                                            $service = implode(' ', $service);

                                                            echo ucfirst($serviceType) . '<br/>' . $service;
                                                        @endphp
                                                    @else
                                                        @lang('N/A')
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($data->status == 2)
                                                        <span class="badge badge-warning style--light">@lang('Pending')</span>
                                                    @elseif($data->status == 1)
                                                        <span class="badge badge-success style--light">@lang('Approved')</span>
                                                    @elseif($data->status == 3)
                                                        <span class="badge badge-danger style--light">@lang('Rejected')</span>
                                                    @endif

                                                </td>
                                                <td>
                                                    {{ showDateTime($data->created_at, 'm-d-Y') }}
                                                </td>
                                                <td>
                                                    @php
                                                        $details = [];
                                                        foreach (json_decode(@$data->user_data) ?? [] as $key => $info) {
                                                            $details[] = $info;
                                                            if ($info->type == 'file') {
                                                                $details[$key]->value = route('user.download.attachment', encrypt(getFilePath('verify') . '/' . $info->value));
                                                            }
                                                        }
                                                    @endphp

                                                    <a href="javascript:void(0)" class="icon-btn bg-primary text-white detailBtn ml-2" data-message="{{ $data->admin_feedback }}" data-details="{{ json_encode($details) }}">
                                                        <i class="las la-desktop"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="100%" class="text-center">{{ __($emptyMessage) }}</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                {{ $histories->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    <!-- dashboard end -->

    {{-- Detail MODAL --}}
    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header ">
                    <h5 class="modal-title">@lang('Details')!</h5>
                    <button type="button" class="close bg-transparent" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times text-black"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <h6>@lang('Admin Feedback')</h6>
                    <div class="admin_feedback"></div>

                    <div class="detailsArea mt-4">

                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark text-white" data-bs-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {

            "use strict";

            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                var feedback = $(this).data('message');

                if (!feedback) {
                    feedback = '@lang('No Feedback')';
                }

                var details = $(this).data('details');
                var singleInfo = '';

                modal.find('.admin_feedback').html(`<p> ${feedback} </p>`);

                if (details) {
                    details.forEach(element => {
                        if (element.type != 'file') {
                            singleInfo += `
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${element.name}</span>
                                <span">${element.value}</span>
                            </li>`;
                        } else {
                            singleInfo += `
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${element.name}</span>
                                <span"><a class="text--base" href="${element.value}"><i class="fa-regular fa-file"></i> @lang('Attachment')</a></span>
                            </li>`;
                        }
                    });
                }

                modal.find('.detailsArea').html(`${singleInfo}`);

                modal.modal('show');
            });
            $('.main-wrapper').addClass('section--bg');

        })(jQuery);
    </script>
@endpush
