@extends($activeTemplate . 'layouts.master')
@section('content')
    <!-- dashboard start -->
    <section class="pt-120 pb-120 section--bg">
        <div class="container">

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">

                        <div class="card-body p-0">
                            <div class="table-responsive--md">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>@lang('Name')</th>
                                            <th>@lang('Email')</th>
                                            <th>@lang('Mobile')</th>
                                            <th>@lang('Join At')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($downlines as $data)
                                            <tr>
                                                <td>
                                                    <b>{{ __($data->fullname) }}</b>
                                                </td>
                                                <td>
                                                    {{ __($data->email) }}
                                                </td>
                                                <td>
                                                    {{ __($data->mobile) }}
                                                </td>
                                                <td>
                                                    {{ showDateTime($data->created_at) }}
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="100%" class="text-center">{{ __($emptyMessage) }}</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>

                                {{ $downlines->links() }}

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    <!-- dashboard end -->
@endsection


@push('script')
    <script>
        "use strict";

        $('.main-wrapper').addClass('section--bg');
    </script>
@endpush
