@extends($activeTemplate . 'layouts.authenticate')

@section('content')
    @php
        $footer = getContent('footer.content', true);
        $pages = getContent('pages.element');
        $bg = getContent('auth_image.content', true);
    @endphp

    <div class="account-area">
        <div class="account-area-bg bg_img" data-background="{{ frontendImage('auth_image', @$bg->data_values->image, '1920x1080') }}"></div>
        <div class="account-wrapper">
            <div class="account-logo text-center">
                <a class="site-logo site-title" href="{{ route('home') }}"><img src="{{ siteLogo() }}" alt="Logo"></a>
            </div>
            @if (gs('registration'))
                @include($activeTemplate . 'partials.social_login')
                <form action="{{ route('user.register') }}" method="POST"
                      class="account-form verify-gcaptcha disableSubmission">
                    @csrf
                    <div class="row">
                        @if (session()->get('reference') != null)
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">@lang('Reference by')</label>
                                    <input type="text" name="referBy" class="form-control form--control" value="{{ session()->get('reference') }}" readonly disabled>
                                </div>
                            </div>
                        @endif
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="form-label">@lang('First Name')</label>
                                <input type="text" class="form-control form--control" name="firstname" value="{{ old('firstname') }}" required>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Last Name')</label>
                                <input type="text" class="form-control form--control" name="lastname" value="{{ old('lastname') }}" required>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">@lang('Email Address')</label>
                                <input type="email" class="form-control form--control checkUser" name="email" value="{{ old('email') }}" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Password')</label>
                                <input type="password" class="form-control form--control @if (gs('secure_password')) secure-password @endif" name="password" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">@lang('Confirm Password')</label>
                                <input type="password" class="form-control form--control" name="password_confirmation" required>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <x-captcha />
                            @if (gs('agree'))
                                @php
                                    $policyPages = getContent('policy_pages.element', false, orderById: true);
                                @endphp
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="agree"
                                           @checked(old('agree')) name="agree" required>
                                    <label class="form-check-label" for="agree">
                                        @lang('I agree with')
                                        @foreach ($policyPages as $policy)
                                            <a class="text--base" href="{{ route('policy.pages', $policy->slug) }}"
                                               target="_blank">{{ __($policy->data_values->title) }}</a>
                                            @if (!$loop->last)
                                                ,
                                            @endif
                                        @endforeach
                                    </label>
                                </div>
                            @endif
                        </div>
                    </div>
                    <button type="submit" id="recaptcha" class="cmn-btn w-100 my-3"> @lang('Register')</button>
                </form>
                <p class="text-center">@lang('Already have an account?') <a class="text--base" href="{{ route('user.login') }}">@lang('Login')</a></p>
            @else
                @include($activeTemplate . 'partials.registration_disabled')
            @endif
            <div class="account-footer text-center">
                {{ __(@$footer->data_values->text) }}
            </div>
        </div>
    </div>
    <div class="modal fade" id="existModalCenter" tabindex="-1" role="dialog" aria-labelledby="existModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="existModalLongTitle">@lang('You are with us')</h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <h6 class="text-center">@lang('You already have an account please Login ')</h6>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark btn-sm" data-bs-dismiss="modal">@lang('Close')</button>
                    <a href="{{ route('user.login') }}" class="btn btn--base btn-sm">@lang('Login')</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@if (gs('registration'))

    @push('style')
        <style>
            .register-disable {
                height: 100vh;
                width: 100%;
                background-color: #fff;
                color: black;
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .register-disable-image {
                max-width: 300px;
                width: 100%;
                margin: 0 auto 32px;
            }

            .register-disable-title {
                color: rgb(0 0 0 / 80%);
                font-size: 42px;
                margin-bottom: 18px;
                text-align: center
            }

            .register-disable-icon {
                font-size: 16px;
                background: rgb(255, 15, 15, .07);
                color: rgb(255, 15, 15, .8);
                border-radius: 3px;
                padding: 6px;
                margin-right: 4px;
            }

            .register-disable-desc {
                color: rgb(0 0 0 / 50%);
                font-size: 18px;
                max-width: 565px;
                width: 100%;
                margin: 0 auto 32px;
                text-align: center;
            }

            .register-disable-footer-link {
                color: #fff;
                background-color: #5B28FF;
                padding: 13px 24px;
                border-radius: 6px;
                text-decoration: none
            }

            .register-disable-footer-link:hover {
                background-color: #440ef4;
                color: #fff;
            }
        </style>
    @endpush

    @if (gs('secure_password'))
        @push('script-lib')
            <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
        @endpush
    @endif

    @push('script')
        <script>
            "use strict";
            (function($) {

                $('.checkUser').on('focusout', function(e) {
                    var url = '{{ route('user.checkUser') }}';
                    var value = $(this).val();
                    var token = '{{ csrf_token() }}';

                    var data = {
                        email: value,
                        _token: token
                    }

                    $.post(url, data, function(response) {
                        if (response.data != false) {
                            $('#existModalCenter').modal('show');
                        }
                    });
                });
            })(jQuery);
        </script>
    @endpush

@endif
