@extends($activeTemplate . 'layouts.authenticate')

@section('content')
    @php
        $footer = getContent('footer.content', true);
        $bg = getContent('auth_image.content', true);
    @endphp

    <!-- account section start -->
    <div class="account-area">
        <div class="account-area-bg bg_img" data-background="{{ frontendImage('auth_image', @$bg->data_values->image, '1920x1080') }}"></div>
        <div class="account-wrapper">
            <div class="account-logo text-center">
                <a class="site-logo site-title" href="{{ route('home') }}"><img src="{{ siteLogo() }}" alt="Logo"></a>
            </div>

            @include($activeTemplate . 'partials.social_login')

            <form method="POST" action="{{ route('user.login') }}" class="account-form verify-gcaptcha">
                @csrf

                <div class="form-group">
                    <label>@lang('Username or Email')</label>
                    <input type="text" name="username" class="form-control" value="{{ old('username') }}" required>
                </div>
                <div class="form-group">
                    <label>@lang('Password')</label>
                    <input type="password" name="password" class="form-control" required>
                </div>

                <x-captcha />

                <div class="col-md-12">
                    <div class="d-flex flex-wrap justify-content-between">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="remember" id="remember"
                                   {{ old('remember') ? 'checked' : '' }}>
                            <label class="form-check-label" for="remember">
                                @lang('Remember Me')
                            </label>
                        </div>
                        <a class="text-white" href="{{ route('user.password.request') }}"
                           class="p--color font-size--14px">@lang('Forget Password')?</a>
                    </div>
                </div>
                <button type="submit" id="recaptcha" class="cmn-btn mt-3 w-100">
                    @lang('LOGIN NOW')
                </button>
            </form>
            <p class="text-center mt-3">@lang('Don\'t Have an Account?')
                <a href="{{ route('user.register') }}" class="base--color">@lang('Register Now')</a>
            </p>

            <div class="account-footer text-center">
                {{ __(@$footer->data_values->text) }}
            </div>
        </div>
    </div>
    <!-- account section end -->
@endsection

@push('script')
    <script>
        "use strict";

        function submitUserForm() {
            var response = grecaptcha.getResponse();
            if (response.length == 0) {
                document.getElementById('g-recaptcha-error').innerHTML =
                    '<span style="color:red;">@lang('Captcha field is required.')</span>';
                return false;
            }
            return true;
        }

        function verifyCaptcha() {
            document.getElementById('g-recaptcha-error').innerHTML = '';
        }
    </script>
@endpush
