@php
    $text = Request::routeIs('user.register') ? 'Register' : 'Login';
@endphp
<div class="social-login">
    @if (@gs('socialite_credentials')->google->status == Status::ENABLE)
        <a href="{{ route('user.social.login', 'google') }}" class="btn  social-login-btn google">
            <span class="google-icon">
                <img src="{{ asset($activeTemplateTrue . 'images/google.svg') }}" alt="Google">
            </span> @lang("$text with Google")
        </a>
    @endif
    @if (@gs('socialite_credentials')->facebook->status == Status::ENABLE)
        <a href="{{ route('user.social.login', 'facebook') }}" class="btn  social-login-btn facebook">
            <span class="facebook-icon">
                <img src="{{ asset($activeTemplateTrue . 'images/facebook.svg') }}" alt="Facebook">
            </span> @lang("$text with Facebook")
        </a>
    @endif
    @if (@gs('socialite_credentials')->linkedin->status == Status::ENABLE)
        <a href="{{ route('user.social.login', 'linkedin') }}" class="btn  social-login-btn linkedin">
            <span class="facebook-icon">
                <img src="{{ asset($activeTemplateTrue . 'images/linkdin.svg') }}" alt="Linkedin">
            </span> @lang("$text with Linkedin")
        </a>
    @endif
</div>

@if (@gs('socialite_credentials')->linkedin->status || @gs('socialite_credentials')->facebook->status == Status::ENABLE || @gs('socialite_credentials')->google->status == Status::ENABLE)
    <div class="other-option">
        <span class="other-option__text">@lang('OR')</span>
    </div>
@endif

@push('style')
    <style>
        .social-login {
            width: 100%;
            display: flex;
            flex-wrap: wrap;
            gap: 16px;
        }

        .social-login-btn {
            color: rgba(255, 255, 255, 0.8);
            border: 1px solid rgba(255, 255, 255, 0.8);
            flex-grow: 1;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            padding: 12px 0;
        }

        .social-login-btn:hover,
        .social-login-btn:focus {
            color: #fff;
            border: 1px solid #fff;
        }

        .social-login-btn:focus {
            box-shadow: none !important;
        }

        .other-option {
            width: 100%;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1;
            margin: 24px 0;
        }

        .other-option::before {
            content: '';
            width: 100%;
            height: 1px;
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            transform: translateY(-50%);
            background-color: rgba(255, 255, 255, 0.25);
            z-index: -1;
        }

        .other-option__text {
            color: rgba(255, 255, 255, 0.8);
            background-color: #062241;
            line-height: 1;
            display: inline-block;
            padding: 0 10px;
        }
    </style>
@endpush
