@if (gs('multi_language'))
    @php
        $language = App\Models\Language::all();
        $selectedLang = $language->where('code', session('lang'))->first();
    @endphp
    <div class="language dropdown d-xl-block me-2">
        <button class="language-wrapper" data-bs-toggle="dropdown" aria-expanded="false">
            <div class="language-content">
                <div class="language_flag">
                    <img src="{{ getImage(getFilePath('language') . '/' . @$selectedLang->image, getFileSize('language')) }}" alt="flag">
                </div>
                <p class="language_text_select">{{ __(@$selectedLang->name) }}</p>
            </div>
            <span class="collapse-icon"><i class="las la-angle-down"></i></span>
        </button>
        <div class="dropdown-menu langList_dropdow py-2" style="">
            <ul class="langList">
                @foreach ($language as $item)
                    <li class="language-list langSel" data-code="{{ $item->code }}">
                        <div class="language_flag">
                            <img src="{{ getImage(getFilePath('language') . '/' . $item->image, getFileSize('language')) }}" alt="flag">
                        </div>
                        <p class="language_text">{{ $item->name }}</p>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
@endif

@push('script')
    <script>
        $(".langSel").on("click", function() {
            window.location.href = "{{ route('home') }}/change/" + $(this).data('code');
        });
    </script>
@endpush


<style>
    .language-wrapper {
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 12px;
        padding: 5px 12px;
        border-radius: 4px;
        width: 130px;
        background-color: rgb(255 255 255 / 3%);
        border: 1px solid rgba(255, 255, 255, 0.1) !important;
        height: 38px;
    }

    .language_flag {
        flex-shrink: 0
    }

    .language_flag img {
        height: 20px;
        width: 20px;
        object-fit: cover;
        border-radius: 50%;
    }

    .language-wrapper.show .collapse-icon {
        transform: rotate(180deg)
    }

    .collapse-icon {
        font-size: 14px;
        display: flex;
        transition: all linear 0.2s;
        color: rgb(255 255 255)
    }

    .language_text_select {
        font-size: 14px;
        font-weight: 400;
        color: rgb(255 255 255)
    }

    .language-content {
        display: flex;
        align-items: center;
        gap: 6px;
    }


    .language_text {
        color: #ffffff
    }

    .language-list {
        display: flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        cursor: pointer;
    }

    .language .dropdown-menu {
        position: absolute;
        -webkit-transition: ease-in-out 0.1s;
        transition: ease-in-out 0.1s;
        opacity: 0;
        visibility: hidden;
        top: 100%;
        display: unset;
        background: #063862;
        -webkit-transform: scaleY(1);
        transform: scaleY(1);
        min-width: 150px;
        padding: 7px 0 !important;
        border-radius: 8px;
        border: 1px solid rgb(255 255 255 / 10%);
    }

    .language .dropdown-menu.show {
        visibility: visible;
        opacity: 1;
    }
</style>
