@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Date')</th>
                                    <th>@lang('Category')</th>
                                    <th>@lang('Service')</th>
                                    <th>@lang('Username')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Charge')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($services as $index => $data)
                                    <tr>
                                        <td>
                                            {{ showDateTime(@$data->created_at) }}
                                        </td>
                                        <td>
                                            {{ __(@$data->service->category->name) }}
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.service.update.page', $data->service_id) }}">
                                                {{ __(@$data->service->name) }}
                                            </a>
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.users.detail', $data->user_id) }}">
                                                {{ __(@$data->user->username) }}
                                            </a>
                                        </td>
                                        <td>
                                            {{ getAmount($data->amount) }}
                                            {{ __(gs()->cur_text) }}
                                        </td>
                                        <td>
                                            {{ getAmount($data->total_charge) }}
                                            {{ __(gs()->cur_text) }}
                                        </td>
                                        <td>
                                            @if ($data->status == 2)
                                                <span class="badge badge--warning">@lang('Pending')</span>
                                            @elseif($data->status == 1)
                                                <span class="badge badge--success">@lang('Approved')</span>
                                            @else
                                                <span class="badge badge--danger">@lang('Rejected')</span>
                                            @endif
                                        </td>
                                        <td>

                                            <a href="{{ route('admin.applied.details', $data->id) }}" class="btn btn-sm btn-outline--primary ms-1" data-toggle="tooltip" data-original-title="@lang('Details')"
                                                data-id="{{ $data->id }}" data-name="{{ __($data->id) }}">
                                                <i class="la la-eye"></i> @lang('View')
                                            </a>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }} !</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($services->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($services) }}
                    </div>
                @endif
            </div><!-- card end -->
        </div>
    </div>
@endsection
