@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Category')</th>
                                    <th>@lang('Service')</th>
                                    <th>@lang('Processig Time')</th>
                                    <th>@lang('Fixed Charge')</th>
                                    <th>@lang('Parcent Charge')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($services as $index => $data)
                                    <tr>
                                        <td>
                                            {{ __(@$data->category->name) }}
                                        </td>
                                        <td>
                                            {{ __(@$data->name) }}
                                        </td>
                                        <td>
                                            {{ __(@$data->delay) }}
                                        </td>
                                        <td>
                                            {{ getAmount($data->fixed_charge) }}
                                            {{ __(gs()->cur_text) }}
                                        </td>
                                        <td>
                                            {{ getAmount($data->percent_charge) }} @lang('%')
                                        </td>
                                        <td>
                                            @php
                                                echo $data->statusBadge;
                                            @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <a href="{{ route('admin.service.update.page', $data->id) }}" class="btn btn-sm btn-outline--primary eidtBtn" data-toggle="tooltip" data-original-title="@lang('Edit')">
                                                    <i class="la la-pencil"></i> @lang('Edit')
                                                </a>

                                                @if ($data->status == Status::DISABLE)
                                                    <button class="btn btn-sm btn-outline--success confirmationBtn" data-question="@lang('Are you sure to enable this service?')" data-action="{{ route('admin.service.status', $data->id) }}">
                                                        <i class="la la-eye"></i>@lang('Enable')
                                                    </button>
                                                @else
                                                    <button class="btn btn-sm btn-outline--danger confirmationBtn" data-question="@lang('Are you sure to disable this service?')" data-action="{{ route('admin.service.status', $data->id) }}">
                                                        <i class="la la-eye-slash"></i>@lang('Disable')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }} !</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($services->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($services) }}
                    </div>
                @endif
            </div><!-- card end -->
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form />
    <a class="btn btn-outline--primary" href="{{ route('admin.service.page') }}"><i class="la la-plus"></i>@lang('Add New')</a>
@endpush


@push('script')
    <script>
        (function($) {

            "use strict";

            $('.activateBtn').on('click', function() {
                var modal = $('#activateModal');
                modal.find('.method-name').text($(this).data('name'));
                modal.find('input[name=id]').val($(this).data('id'));
                modal.modal('show');
            });

            $('.deactivateBtn').on('click', function() {
                var modal = $('#deactivateModal');
                modal.find('.method-name').text($(this).data('name'));
                modal.find('input[name=id]').val($(this).data('id'))
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
