@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <form action="{{ route('admin.service.update') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <input type="hidden" name="id" value="{{ $service->id }}">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Category') </label>
                                    <select name="category_id" id="category_id" class="form-control select2" data-minimum-results-for-search="-1" required="">
                                        <option value="">@lang('Select category')</option>
                                        @foreach ($categories as $data)
                                            <option {{ $data->id == $service->category_id ? 'selected' : '' }} value="{{ $data->id }}" data-type="{{ $data->field_type }}"
                                                    data-name="{{ str_replace('_', ' ', ucfirst($data->field_name)) }}" data-origin="{{ $data->field_name }}">{{ __($data->name) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Processing Time') </label>
                                    <div class="input-group">
                                        <input type="text" name="delay" value="{{ $service->delay }}" class="form-control border-radius-5" value="{{ old('delay') }}" required="" />
                                    </div>

                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Service Name')</label>

                                    <div class="input-group">
                                        <input type="text" name="name" value="{{ $service->name }}" class="form-control" id="name" required>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Icon') </label>
                                    <div class="input-group">
                                        <input type="text" class="form-control iconPicker icon" name="icon" value="{{ $service->icon }}" required>
                                        <button class="input-group-text  input-group-addon" data-icon="las la-home" role="iconpicker"></button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Fixed Charge') </label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="0" name="fixed_charge" value="{{ getAmount($service->fixed_charge) }}" required="" />
                                        <div class="input-group-text"> {{ __(gs()->cur_text) }} </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Percent Charge') </label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" required="" placeholder="0" name="percent_charge" value="{{ getAmount($service->percent_charge) }}">
                                        <div class="input-group-text">%</div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-lg-12 selectElement">
                                <div class="card border--primary my-2">
                                    <h5 class="card-header bg--primary selectName"> {{ __($label) }} </h5>
                                    <div class="card-body">

                                        <div class="form-group">
                                            <div class="form-group mb-md-0 mb-4">
                                                <select name="select[]" id="multipleSelect" class="form-control select2-auto-tokenize" multiple="multiple">
                                                </select>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>


                            <div class="col-lg-12">
                                <div class="card border--primary my-2">

                                    <h5 class="card-header bg--primary">@lang('Service Instruction') </h5>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <textarea rows="5" class="form-control border-radius-5 nicEdit" name="description">{!! $service->description !!}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">

                                <div class="submitRequired bg--warning form-change-alert d-none mt-3"><i class="fas fa-exclamation-triangle"></i> @lang('You\'ve to click on the submit button to apply the changes')</div>

                                <div class="card border--primary">
                                    <h5 class="card-header bg--primary d-flex justify-content-between align-items-center">@lang('User data')

                                        <button type="button" class="btn btn-sm btn-outline-light float-end form-generate-btn"> <i class="la la-fw la-plus"></i>@lang('Add New')</button>

                                    </h5>

                                    <div class="card-body">
                                        <x-generated-form :form=$form />

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Update Service')</button>
                    </div>
                </form>
            </div>
        </div>
        <x-form-generator-modal />
    @endsection

    @push('breadcrumb-plugins')
        <x-back route="{{ route('admin.service') }}" />
    @endpush

    @push('style-lib')
        <link href="{{ asset('assets/admin/css/fontawesome-iconpicker.min.css') }}" rel="stylesheet">
    @endpush

    @push('script-lib')
        <script src="{{ asset('assets/admin/js/fontawesome-iconpicker.js') }}"></script>
    @endpush


    @push('script')
        <script>
            (function($) {

                "use strict";

                var selectField = @json($service->select_field);

                if (!selectField) {
                    $('.selectElement').hide();
                    $('.dynamic-form').hide();
                } else {
                    var datas = @json($values);
                    var select = $('#multipleSelect');
                    var $newOption = '';
                    for (let i = 0; i < datas.length; i++) {
                        select.append(
                            $(`<option selected>`).val(datas[i]).text(datas[i])
                        )
                    }
                }


                $('input[name=currency]').on('input', function() {
                    $('.currency_symbol').text($(this).val());
                });



                $('#category_id').on('change', function() {

                    var field_type = $(this).children("option:selected").data('type');
                    var field_name = $(this).children("option:selected").data('name');
                    var originalName = $(this).children("option:selected").data('origin');
                    var select = $('#multipleSelect');
                    select.empty();

                    if (!field_type) {
                        $('.dynamic-form').hide();
                        select.empty();
                        return;
                    }

                    $('.dynamic-form').show();

                    var label = @json($label);
                    var values = @json($values);

                    if (field_type == 'select') {
                        $('.selectName').text(field_name);
                        $('.selectElement').show();

                        if (originalName == label) {

                            if (values) {
                                var datas = values;
                                var $newOption = '';
                                for (let i = 0; i < datas.length; i++) {
                                    select.append(
                                        $(`<option selected>`).val(datas[i]).text(datas[i])
                                    )
                                }
                            }

                        } else {
                            select.empty();
                        }

                    }

                }).change();

                $('.iconPicker').iconpicker().on('iconpickerSelected', function(e) {
                    $(this).closest('.form-group').find('.iconpicker-input').val(`<i class="${e.iconpickerValue}"></i>`);
                });

            })(jQuery);
        </script>
    @endpush


    @push('style')
        <style>
            .select2-container--default .select2-selection--multiple .select2-selection__choice__display,
            .select2-container--default .select2-selection--multiple .select2-selection__choice__remove span {
                font-size: 17px !important;
            }

            input::-webkit-outer-spin-button,
            input::-webkit-inner-spin-button {
                -webkit-appearance: none;
                margin: 0;
            }

            input[type=number] {
                -moz-appearance: textfield;
            }
        </style>
    @endpush
