@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <form action="{{ route('admin.service.store') }}" method="POST" id="serviceForm">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Category')</label>
                                    <select name="category_id" id="category_id" class="form-control select2" data-minimum-results-for-search="-1" required>
                                        <option value="">@lang('Select category')</option>
                                        @foreach ($categories as $data)
                                            <option value="{{ $data->id }}" data-type="{{ $data->field_type }}" data-name="{{ str_replace('_', ' ', ucfirst($data->field_name)) }}">{{ __($data->name) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Processing Time')</label>
                                    <input type="text" name="delay" class="form-control" value="{{ old('delay') }}" required="" />
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Service Name')</label>
                                    <input type="text" name="name" class="form-control" id="name" value="{{ old('name') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Icon') </label>
                                    <div class="input-group">
                                        <input type="text" class="form-control iconPicker icon" name="icon" value="{{ old('icon') }}" required>
                                        <span class="input-group-text  input-group-addon" data-icon="las la-home" role="iconpicker"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Fixed Charge') </label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="0" name="fixed_charge" value="{{ old('fixed_charge') }}" required="" />
                                        <div class="input-group-text"> {{ __(gs()->cur_text) }} </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Percent Charge') </label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" required="" placeholder="0" name="percent_charge" value="{{ old('percent_charge') }}">
                                        <div class="input-group-text">%</div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-lg-12 selectElement">
                                <div class="card border--primary my-2">
                                    <h5 class="card-header bg--primary selectName"> </h5>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <div class="form-group mb-md-0 mb-4">
                                                <select name="select[]" class="form-control select2-auto-tokenize" multiple="multiple"></select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="card border--dark my-2">

                                    <h5 class="card-header bg--primary">@lang('Service Instruction') </h5>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <textarea rows="5" class="form-control border-radius-5 nicEdit" name="description">{{ old('description') }}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="submitRequired bg--warning form-change-alert d-none mt-3"><i class="fas fa-exclamation-triangle"></i> @lang('You\'ve to click on the submit button to apply the changes')</div>

                                <div class="card border--primary">
                                    <h5 class="card-header bg--primary d-flex justify-content-between align-items-center">@lang('User data')
                                        <button type="button" class="btn btn-sm btn-outline-light float-end form-generate-btn"> <i class="la la-fw la-plus"></i>@lang('Add New')</button>
                                    </h5>
                                    <div class="card-body">
                                        <x-generated-form />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45 submitBtn">@lang('Save Service')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-form-generator-modal />
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.service') }}" />
@endpush

@push('style-lib')
    <link href="{{ asset('assets/admin/css/fontawesome-iconpicker.min.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/fontawesome-iconpicker.js') }}"></script>
@endpush



@push('script')
    <script>
        (function($) {

            "use strict";

            $('.selectElement').hide();
            $('.dynamic-form').hide();

            $('input[name=currency]').on('input', function() {
                $('.currency_symbol').text($(this).val());
            });


            var existsCategory = @json(count($categories));
            if (!existsCategory) {
                $("input, select, option, textarea, .submitBtn", "#serviceForm").prop('disabled', true);
                notify('error', 'Service category not found');
            }

            $(document).on('change', '#category_id', function() {

                var field_type = $(this).children("option:selected").data('type');
                var field_name = $(this).children("option:selected").data('name');

                if (!field_type) {
                    $('.dynamic-form').hide();
                    return;
                }

                $('.dynamic-form').show();

                if (field_type == 'select') {
                    $('.selectName').text(field_name);
                    $('.selectElement').show();
                }

            });

            $('.iconPicker').iconpicker().on('iconpickerSelected', function(e) {
                $(this).closest('.form-group').find('.iconpicker-input').val(`<i class="${e.iconpickerValue}"></i>`);
            });

        })(jQuery);
    </script>
@endpush


@push('style')
    <style>
        .select2-container--default .select2-selection--multiple .select2-selection__choice__display,
        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove span {
            font-size: 17px !important;
        }

        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        input[type=number] {
            -moz-appearance: textfield;
        }
    </style>
@endpush
