@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Category')</th>
                                    <th>@lang('Field Name')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($categories as $index => $data)
                                    <tr>
                                        <td>
                                            {{ __($data->name) }}
                                        </td>
                                        <td>
                                            @if ($data->field_name)
                                                {{ str_replace('_', ' ', ucfirst($data->field_name)) }}
                                            @else
                                                @lang('N/A')
                                            @endif
                                        </td>
                                        <td>
                                            @php
                                                echo $data->statusBadge;
                                            @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <button type="button" class="btn btn-sm btn-outline--primary eidtBtn" data-toggle="tooltip" data-original-title="@lang('Edit')" data-id='{{ $data->id }}'
                                                        data-name='{{ $data->name }}' data-status='{{ $data->status }}' data-field_name='{{ str_replace('_', ' ', ucfirst($data->field_name)) }}'
                                                        data-field_type='{{ $data->field_type }}'>
                                                    <i class="la la-pencil"></i> @lang('Edit')
                                                </button>
                                                @if ($data->status == Status::DISABLE)
                                                    <button type="button"
                                                            class="btn btn-sm btn-outline--success  confirmationBtn"
                                                            data-action="{{ route('admin.service.category.status', $data->id) }}"
                                                            data-question="@lang('Are you sure to enable this service category?')">
                                                        <i class="la la-eye"></i> @lang('Enable')
                                                    </button>
                                                @else
                                                    <button type="button" class="btn btn-sm btn-outline--danger confirmationBtn"
                                                            data-action="{{ route('admin.service.category.status', $data->id) }}"
                                                            data-question="@lang('Are you sure to disable this service category?')">
                                                        <i class="la la-eye-slash"></i> @lang('Disable')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }} !</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($categories->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($categories) }}
                    </div>
                @endif
            </div><!-- card end -->
        </div>
    </div>

    <!-- ADD MODAL -->
    <div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel">@lang('New Service Category')</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>

                <form action="{{ route('admin.service.category.store') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12 form-group">
                                <label for="name">@lang('Name') </label>
                                <input type="text" id="name" value="{{ old('name') }}" class="form-control" name="name" required>
                            </div>
                            <div class="col-lg-12 form-group">
                                <label for="field_name">@lang('Field Name')</label>
                                <input type="text" id="field_name" value="{{ old('field_name') }}" class="form-control" name="field_name">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Save')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- EDIT MODAL -->
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Edit Service Category')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.service.category.update') }}" method="POST">
                    @csrf

                    <div class="modal-body">
                        <div class="row">
                            <input type="hidden" name="id">
                            <div class="col-lg-12 form-group">
                                <label for="name2">@lang('Name') </label>
                                <input type="text" id="name2" value="{{ old('name') }}" class="form-control" name="name" required>
                            </div>
                            <div class="col-lg-12 form-group">
                                <label for="field_name2">@lang('Field Name')</label>
                                <input type="text" id="field_name2" value="{{ old('field_name') }}" class="form-control" name="field_name">
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Update')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form />

    <a class="btn btn-outline--primary add-btn" href="javascript:void(0)"><i class="la la-plus"></i>@lang('Add New')</a>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $(document).on('click', '.add-btn', function() {
                var modal = $('#addModal');
                modal.modal('show');
            });

            $(document).on('click', '.eidtBtn', function() {
                var modal = $('#editModal');
                var status = $(this).data('status');
                modal.find('input[name=id]').val($(this).data('id'));
                modal.find('input[name=name]').val($(this).data('name'));
                modal.find('select[name=field_type]').val($(this).data('field_type'));
                modal.find('input[name=field_name]').val($(this).data('field_name'));
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
