@extends('admin.layouts.app')
@section('panel')
    <div class="row mb-none-30">
        <div class="col-xl-4 col-md-6 mb-30">
            <div class="card b-radius--10 overflow-hidden box--shadow1">
                <div class="card-body">
                    <div class="p-3 bg--white">

                    </div>

                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Date')
                            <span class="fw-bold">{{ showDateTime(@$service->created_at) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Username')
                            <span class="fw-bold">
                                <a href="{{ route('admin.users.detail', $service->user_id) }}">
                                    {{ __(@$service->user->fullname) }}
                                </a>
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Category')
                            <span class="fw-bold">
                                {{ __(@$service->service->category->name) }}
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Service')
                            <span class="fw-bold">
                                <a href="{{ route('admin.service.update.page', $service->service_id) }}">
                                    {{ __(@$service->service->name) }}
                                </a>
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Amount')
                            <span class="fw-bold">
                                {{ getAmount($service->amount) }}
                                {{ __(gs()->cur_text) }}
                            </span>

                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Total Charge')
                            <span class="fw-bold">
                                {{ getAmount($service->total_charge) }}
                                {{ __(gs()->cur_text) }}
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('After Charge')
                            <span class="fw-bold">
                                {{ getAmount($service->after_charge) }}
                                {{ __(gs()->cur_text) }}
                            </span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @lang('Status')
                            @if ($service->status == 2)
                                <span class="badge badge--warning">@lang('Pending')</span>
                            @elseif($service->status == 1)
                                <span class="badge badge--success">@lang('Approved')</span>
                            @elseif($service->status == 3)
                                <span class="badge badge--danger">@lang('Rejected')</span>
                            @endif
                        </li>
                    </ul>

                    @if ($service->admin_feedback)
                        <div class="mt-4">
                            <span class="d-block fw-bold">@lang('Admin Feedback')</span>
                            <span>{{ __($service->admin_feedback) }}</span>
                        </div>
                    @endif

                </div>
            </div>
        </div>
        <div class="col-xl-8 col-md-6 mb-30">
            <div class="card b-radius--10 overflow-hidden box--shadow1">
                <div class="card-body">
                    <h5 class="card-title border-bottom pb-2">
                        {{ __(@$service->service->category->name) }}
                        @lang('Information')
                    </h5>

                    @if ($service->select_field)
                        @php
                            $select = (array) json_decode($service->select_field);
                            $serviceType = key($select);
                            $serviceValue = array_values($select);
                            $serviceValue = implode(' ', $serviceValue);
                        @endphp
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <p>{{ ucfirst($serviceType) }}</p>
                                <h6>{{ $serviceValue }}</h6>
                            </div>
                        </div>
                    @endif

                    @if (@$service->user_data)
                        @foreach (json_decode(@$service->user_data ?? []) as $val)
                            <div class="row mt-4">
                                <div class="col-md-12">
                                    <h6>{{ __($val->name) }}</h6>
                                    @if ($val->type == 'checkbox')
                                        {{ implode(',', $val->value) }}
                                    @elseif($val->type == 'file')
                                        @if ($val->value)
                                            <a href="{{ route('admin.download.attachment', encrypt(getFilePath('verify') . '/' . $val->value)) }}"><i class="fa-regular fa-file"></i> @lang('Attachment') </a>
                                        @else
                                            @lang('No File')
                                        @endif
                                    @else
                                        <p>{{ __($val->value) }}</p>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    @endif

                    @if ($service->status == Status::DATA_PENDING)
                        <div class="row mt-4">
                            <div class="col-md-12">

                                <button class="btn btn-outline--success btn-sm ms-1 confirmationBtn" data-action="{{ route('admin.applied.approve', $service->id) }}" data-question="@lang('Are you sure to approve this service ?')"><i
                                       class="las la-check"></i>
                                    @lang('Approve')
                                </button>

                                <button class="btn btn-outline--danger btn-sm ms-1 cancelBtn" data-id="{{ $service->id }}" data-name="{{ $service->service->category->name }}" data-toggle="tooltip"
                                        data-original-title="@lang('Reject')"><i class="fas fa-ban"></i>
                                    @lang('Reject')
                                </button>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>


    {{-- CANCEL MODAL --}}
    <div id="rejectModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Reject Service Confirmation')!</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="{{ route('admin.applied.reject') }}" method="POST">
                    @csrf
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <p>@lang('Are you sure to') <span class="fw-bold">@lang('cancel')</span> <span class="fw-bold withdraw-amount text-success"></span> @lang('the service of') <span
                                  class="fw-bold withdraw-user fw-bold"></span>?</p>

                        <div class="form-group">
                            <label class="fw-bold mt-2">@lang('Reason for cancellation')</label>
                            <textarea name="message" id="message" placeholder="@lang('Reason for Cancellation')" class="form-control" rows="5" required></textarea>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('script')
    <script>
        (function($) {

            "use strict";

            $('.approveBtn').on('click', function() {
                var modal = $('#approveModal');
                modal.find('input[name=id]').val($(this).data('id'));
                modal.find('.withdraw-user').text($(this).data('name'));
                modal.modal('show');
            });

            $('.cancelBtn').on('click', function() {
                var modal = $('#rejectModal');
                modal.find('input[name=id]').val($(this).data('id'));
                modal.find('.withdraw-user').text($(this).data('name'));
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
