<?php
header("Content-Type:text/css");
$color = "#f0f"; // Change your Color Here
$secondColor = "#ff8"; // Change your Color Here

function checkhexcolor($color)
{
	return preg_match('/^#[a-f0-9]{6}$/i', $color);
}

if (isset($_GET['color']) and $_GET['color'] != '')
{
	$color = "#" . $_GET['color'];
}

if (!$color or !checkhexcolor($color))
{
	$color = "#336699";
}


function checkhexcolor2($secondColor)
{
	return preg_match('/^#[a-f0-9]{6}$/i', $secondColor);
}

if (isset($_GET['secondColor']) and $_GET['secondColor'] != '')
{
	$secondColor = "#" . $_GET['secondColor'];
}

if (!$secondColor or !checkhexcolor2($secondColor))
{
	$secondColor = "#336699";
}




function hexToHsl($hex)
{
	$hex   = str_replace('#', '', $hex);
	$red   = hexdec(substr($hex, 0, 2)) / 255;
	$green = hexdec(substr($hex, 2, 2)) / 255;
	$blue  = hexdec(substr($hex, 4, 2)) / 255;
	$cmin  = min($red, $green, $blue);
	$cmax  = max($red, $green, $blue);
	$delta = $cmax - $cmin;
	if ($delta == 0)
	{
		$hue = 0;
	}
	elseif ($cmax === $red)
	{
		$hue = (($green - $blue) / $delta);
	}
	elseif ($cmax === $green)
	{
		$hue = ($blue - $red) / $delta + 2;
	}
	else
	{
		$hue = ($red - $green) / $delta + 4;
	}
	$hue = round($hue * 60);
	if ($hue < 0)
	{
		$hue += 360;
	}
	$lightness  = (($cmax + $cmin) / 2);
	$saturation = $delta === 0 ? 0 : ($delta / (1 - abs(2 * $lightness - 1)));
	if ($saturation < 0)
	{
		$saturation += 1;
	}
	$lightness  = round($lightness * 100);
	$saturation = round($saturation * 100);
	$hsl['h']   = $hue;
	$hsl['s']   = $saturation;
	$hsl['l']   = $lightness;
	return $hsl;
}
?>


.preloader .animated-preloader, .preloader .animated-preloader::before, .bill-items-wrapper .bill-items .nav-item.active .nav-link i, .bill-items-wrapper .bill-items .nav-item::after, .bill-items-wrapper .bill-items .nav-item:hover .nav-link i, .cmn-btn, .scroll-to-top .scroll-icon, .feature-card:hover .feature-card__icon, .social-links.style--two li a, .d-widget__icon, .d-widget::before, .d-widget__btn, .client-slider .slick-arrow:hover, .service-card:hover, .table thead,.cookies-card__icon{
background: <?php echo $color; ?>;
}

.header .main-menu li a:hover, .header .main-menu li a:focus, .section-top-title, .service-card__icon i, .feature-card__icon i, .overview-card__icon i, .social-links li a:hover, .page-breadcrumb li:first-child::before, .contact-card__header i, a:hover, .d-widget.style--two .d-widget__icon i{
color: <?php echo $color; ?>;
}

.overview-card__icon i {
text-shadow: 0 5px 10px <?php echo $color; ?>75;
}

.base--color, .header-account-list li a:hover{
color: <?php echo $color; ?> !important;
}
.profile-thumb .avatar-edit label {
background-color: <?php echo $color; ?> !important;
color: #fff !important;
}
.feature-card:hover .feature-card__icon{
box-shadow: 0 15px 35px <?php echo $color; ?>73;
}

.bg-primary, a.bg-primary:focus, a.bg-primary:hover, button.bg-primary:focus, button.bg-primary:hover{
background: <?php echo $color; ?> !important;
}

.form-control:focus {
border-color: <?php echo $color; ?>;
box-shadow: 0 0 5px <?php echo $color; ?>59;
}


.select2-container--focus,
.select2-container--open {
	box-shadow: 0 0 5px <?php echo $color; ?>59 !important;
}

.select2-container--focus .select2-selection--single,
.select2-container--open  .select2-selection--single {
	border-color: <?php echo $color; ?> !important;
}

.d-widget__icon::after{
border: 3px solid <?php echo $color; ?>;
}

.btn.focus, .btn:focus{
box-shadow: 0 0 0 0.2rem <?php echo $color; ?>40;;
}

.footer::before{
background-color: <?php echo $secondColor; ?>;
}

.base--bg-two{
background-color: <?php echo $secondColor; ?> !important;
}

:root{
--base-h: <?php echo hexToHsl($color)['h']; ?>;
--base-s: <?php echo hexToHsl($color)['s']; ?>%;
--base-l: <?php echo hexToHsl($color)['l']; ?>%;
--base-two-h: <?php echo hexToHsl($secondColor)['h']; ?>;
--base-two-s: <?php echo hexToHsl($secondColor)['s']; ?>%;
--base-two-l: <?php echo hexToHsl($secondColor)['l']; ?>%;

--base: var(--base-h) var(--base-s) var(--base-l)
}